/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

/////////////////////////////////////////////////////////////////////////////////

const float sphsize=.75;
const float dist=.7;
const float perturb=.2;
const float displacement=.01;
const float windspeed=.2;
const float steps=140.;
const float stepsize=.015;
const float brightness=0.2;
const float fade=.002;
const float glow=4.;
const int iterations=13;
const float fractparam=.5;
const vec3 offset=vec3(1.5,2.,-0.5);
const vec3 planetcolor=vec3(.5,.2,.1);

float rand(vec2 p) {return fract(sin(dot(p,vec2(2132.342,4323.343)))*1325.2158);}

float surf(vec2 p) {
	p=abs(fract((p+vec2(.5,.3))*vec2(.2,.4))-.5);
	float av=0.;
	for (int i=0; i<16; i++) {
		p=abs(p)/dot(p,p)-.65;
		av+=min(50.,length(p*p));
	}
	return av*.05;
}

float wind(vec3 p) {
	float t=-iGlobalTime*windspeed;
	mat2 rota=mat2(cos(t),sin(t),-sin(t),cos(t));
	float d=max(0.,dist-max(0.,length(p)-sphsize)/sphsize)/dist;	
	//p.y*=1.+max(0.,-p.x-sphsize*.25)*1.5-d*.5;
	p+=d*normalize(p)*perturb;
	//p*=1.+d*.5;
	p.xz*=rota;
	p+=offset;
	p=abs(fract(p*.2)-.5);
	for (int i=0; i<iterations; i++) {
		p=abs(p)/dot(p,p)-fractparam;
	}
	float l=min(20.,length(p));
	return pow(l,1.5)*d*5.+d*glow;
}

void main(void)
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy-.5;
	vec3 dir=vec3(uv,1.);
	dir.x*=iResolution.x/iResolution.y;
	vec3 from=vec3(0.,0.,-2.);
	float v=0., l=-0.0001, t=iGlobalTime*windspeed*.2;
	for (float r=30.;r<steps;r++) {
		vec3 p=from+r*dir*stepsize;
		float k=wind(p);
		float tx=texture2D(iChannel0,uv*.2+vec2(t,0.)).x*displacement;
		if (length(p+vec3(0.,0.,rand(uv)*stepsize))-sphsize-tx>0.)
			v+=k*max(0.,1.-r*fade);		
		else if (l<0.) l=surf(uv*(1.+p.z*.5)+vec2(tx+t,0.));
	}
	v/=steps; v*=brightness;
	vec3 col=vec3(v*1.5,v*v,v*v*v*.5)+l*planetcolor;
//	col*=1.-length(pow(abs(uv),vec2(5.)))*15.;
	gl_FragColor = vec4(col,1.0);
}